<?php
/*--------------------------------------------------------------
   StatisticsOverviewService.php 2021-06-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Services;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\WidgetDefinitions;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\Widgets;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Entities\Widget;

interface StatisticsOverviewService
{
    /**
     * Get widgets.
     */
    public function getWidgets(): Widgets;
    
    
    /**
     * Get widget by ID.
     */
    public function getWidgetById(int $id): Widget;
    
    
    /**
     * Get widget definitions.
     */
    public function getWidgetDefinitions(): WidgetDefinitions;
    
    
    /**
     * Add widget.
     */
    public function addWidget(string $type): void;
    
    
    /**
     * Change widget size.
     */
    public function resizeWidget(int $id, int $width, int $height): void;
    
    
    /**
     * Change widget position.
     */
    public function moveWidget(int $id, int $horizontalPosition, int $verticalPosition): void;
    
    
    /**
     * Change widget options.
     */
    public function configureWidget(int $id, array $updateSet): void;
    
    
    /**
     * Delete widget.
     */
    public function deleteWidget(int $id): void;
    
    
    /**
     * Rename widget.
     */
    public function renameWidget(int $id, string $label): void;
}